'use strict';
Object.defineProperty(exports, '__esModule', { value: true });
exports.generateMessageObject = generateMessageObject;
exports.getSentMessageByKey = getSentMessageByKey;
var _baileys = require('../../Baileys');
var _message = require('../message');
var _chat = require('../chat');
const fs = require('fs');
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
  try {
    var info = gen[key](arg);
    var value = info.value;
  } catch (error) {
    reject(error);
    return;
  }
  if (info.done) {
    resolve(value);
  } else {
    Promise.resolve(value).then(_next, _throw);
  }
}
function _asyncToGenerator(fn) {
  return function () {
    var self = this,
      args = arguments;
    return new Promise(function (resolve, reject) {
      var gen = fn.apply(self, args);
      function _next(value) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, 'next', value);
      }
      function _throw(err) {
        asyncGeneratorStep(gen, resolve, reject, _next, _throw, 'throw', err);
      }
      _next(undefined);
    });
  };
}
function generateMessageObject(src) {
  return _generateMessageObject.apply(this, arguments);
}
function _generateMessageObject() {
  _generateMessageObject = _asyncToGenerator(function* (src) {
    let m = new _message.Message(src);
    let inner = src.message;
    if (inner) {
      if (inner.conversation || inner.extendedTextMessage) {
        m = new _message.TextMessage(src);
      } else if (inner.buttonsMessage) {
        m = new _message.TextMessage(src);
        m.content = inner.buttonsMessage.contentText;
      } else if (inner.buttonsResponseMessage) {
        m = new _message.TextMessage(src);
        m.content = inner.buttonsResponseMessage.selectedButtonId;
      } else if (inner.listMessage) {
        m = new _message.TextMessage(src);
        m.content = inner.listMessage.buttonText;
      } else if (inner.listResponseMessage) {
        m = new _message.TextMessage(src);
        m.content = inner.listResponseMessage.singleSelectReply.selectedRowId;
      } else if (inner.templateMessage) {
        m = new _message.TextMessage(src);
        m.content = inner.templateMessage.hydratedTemplate.hydratedContentText;
      } else if (inner.templateButtonReplyMessage) {
        m = new _message.TextMessage(src);
        m.content = inner.templateButtonReplyMessage.selectedId;
      } else if (inner.imageMessage) {
        m = new _message.TextMessage(src);
        m.content = `(${inner.imageMessage.mimetype}) ${inner.imageMessage.caption}`;
      } else if (inner.videoMessage) {
        m = new _message.TextMessage(src);
        m.content = `(${inner.videoMessage.mimetype}) ${inner.videoMessage.caption} ${inner.videoMessage.seconds} seconds`;
      } else if (inner.audioMessage) {
        m = new _message.TextMessage(src);
        m.content = `(${inner.audioMessage.mimetype}) ${inner.audioMessage.seconds} seconds`;
      } else if (inner.documentMessage) {
        m = new _message.TextMessage(src);
        m.content = `(${inner.documentMessage.mimetype}) ${inner.documentMessage.fileName}`;
      } else if (inner.contactMessage) {
        m = new _message.TextMessage(src);
        m.content = `(${inner.contactMessage.displayName}) ${inner.contactMessage.vcard}`;
      } else if (inner.liveLocationMessage) {
        m = new _message.TextMessage(src);
        m.content = `(Live location) \ndegreesLatitude: ${inner.liveLocationMessage.degreesLatitude} \ndegreesLongitude: ${inner.liveLocationMessage.degreesLongitude}`;
      } else if (inner.stickerMessage) {
        m = new _message.TextMessage(src);
        m.content = `(Sticker ${inner.stickerMessage.mimetype}) \nisAnimated: ${inner.stickerMessage.isAnimated} \nisAvatar: ${inner.stickerMessage.isAvatar}`;
        console.log(inner.stickerMessage);
      } else if (inner.contactsArrayMessage) {
        m = new _message.TextMessage(src);
        m.content = `(contactsArrayMessage)`;
        console.log(inner.contactsArrayMessage);
      } else if (inner.orderMessage) {
        m = new _message.TextMessage(src);
        m.content = `(orderMessage)`;
        console.log(inner.orderMessage);
      } else if (inner.productMessage) {
        m = new _message.TextMessage(src);
        m.content = `(productMessage})`;
        console.log(inner.productMessage);
      } else if (inner.pollCreationMessage) {
        m = new _message.TextMessage(src);
        m.content = `(pollCreationMessage)`;
      }
    }
    m.me = this;
    var _from;
    m.from = (0, _baileys).jidNormalizedUser((_from = m.from) !== null && _from !== void 0 ? _from : this.sock.user.id);
    let chat;
    if ((0, _baileys).isJidUser(m.from)) {
      chat = new _chat.Chat();
      chat.name = m.senderName;
    } else if ((0, _baileys).isJidGroup(m.from)) {
      chat = yield _chat.Group.fromJid(this.sock, m.from);
    }
    if (chat) {
      chat.id = m.from;
      chat.me = this;
      m.chat = chat;
    }
    return m;
  });
  return _generateMessageObject.apply(this, arguments);
}
function getSentMessageByKey(key) {
  return _getSentMessageByKey.apply(this, arguments);
}
function _getSentMessageByKey() {
  _getSentMessageByKey = _asyncToGenerator(function* (key) {
    for (const msg of this.sentMessages) {
      if (msg.key.id === key.id) {
        return msg.message;
      }
    }
    return undefined;
  });
  return _getSentMessageByKey.apply(this, arguments);
}
